<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ReportController;

// Redirect root to login
Route::get('/', function () {
    return redirect('/login');
});

// Authentication Routes
Route::get('login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('login', [AuthController::class, 'login']);
Route::post('logout', [AuthController::class, 'logout'])->name('logout');


// Protected Dashboard & Report Routes
Route::middleware('auth')->group(function () {
    Route::get('dashboard', [ReportController::class, 'showDashboard'])->name('dashboard');
    Route::post('generate-report', [ReportController::class, 'generate'])->name('report.generate');
});